﻿using System;
using System.Collections.Generic;
using System.Net;
using System.Xml;

public class TwitterConnectionOAuth : HttpConnectionOAuth {
    public string GetMyScreenName() {
        try {
            string s = "";
            if (this.GetContent("GET", new Uri("https://api.twitter.com/1/account/verify_credentials.xml"), null, ref s, null) != HttpStatusCode.OK) {
                return null;
            }

            var xd = new XmlDocument();
            xd.LoadXml(s);

            return xd.GetElementsByTagName("screen_name")[0].InnerText;

        } catch {
            return null;
        }
    }

    public HttpStatusCode UpdateStatus(string s, ref string content) {
        var param = new Dictionary<string, string>();
        param.Add("status", s);
        return this.GetContent("POST", new Uri("https://api.twitter.com/1/statuses/update.xml"), param, ref content, null);
    }

    public HttpStatusCode DeleteTweet(string id) {
        var content = "";
        return this.GetContent("DELETE", new Uri("http://api.twitter.com/1/statuses/destroy/" + id + ".xml"), null, ref content, null);
    }
}